-- Messaging for THESIS_SUBMISSION Event

SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='USER_MGNT');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'THESIS_SUBMISSION');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='THESIS_SUBMISSION');
INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'THESIS_SUBMISSION', 'Thesis Submission', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Thesis Submission');


SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


-- Template data provider for the THESIS_SUBMISSION

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'THESIS_SUBMISSION_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'THESIS_SUBMISSION_RECIPIENTS', 'SQL');

-- SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
-- INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'BULK_DOCUMENT_DOWNLOAD_TDP', 'CB');


-- Create Recipient Type 

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='THESIS_SUBMISSION_RECIPIENTS');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'THESIS_SUBMISSION_RECIPIENTS');

SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='THESIS_SUBMISSION_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='THESIS_SUBMISSION_RECIPIENTS');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);

-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='THESIS_SUBMISSION_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT DISTINCT
    T5.id AS USER_ID
FROM
    thesis_management T1
        LEFT JOIN
    admission T2 ON T1.admissionId = T2.id
        LEFT JOIN
    students T3 ON T2.studentId = T3.userId
        LEFT JOIN
    persons AS T4 ON T4.id = T3.personId
        LEFT JOIN
    thesis_management_supervisor T5 ON  T1.id = T5.thesisManagementId
		LEFT JOIN
    persons T6 ON T6.id = T5.supervisorId
        LEFT JOIN
    academy_location T7 ON T7.id = T2.academyLocationId
    	LEFT JOIN
	thesis_management_status T8 on T8.thesisManagementId=T1.id
WHERE T1.id in (namedParams) ", NULL);

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='THESIS_SUBMISSION_RECIPIENTS');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`,`sqlQuery`, `jsonString`) 
VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT DISTINCT
    T5.id AS ID,
    T6.firstName AS FIRST_NAME,
    T6.printName AS SUPERVISOR_NAME,
	T6.emailId AS EMAIL_ID,
    T6.mobileNumber AS MOBILE_NO,
    T6.mobileCountryCode AS MOBILE_CODE,
	T8.remarks AS REMARKS,
	T4.printName AS STUDENT_NAME,
    T7.academyName AS ACADEMY_NAME
FROM
    thesis_management T1
        LEFT JOIN
    admission T2 ON T1.admissionId = T2.id
        LEFT JOIN
    students T3 ON T2.studentId = T3.userId
        LEFT JOIN
    users AS T4 ON T4.id = T3.userId
        LEFT JOIN
    thesis_management_supervisor T5 ON  T1.id = T5.thesisManagementId
		LEFT JOIN
    persons T6 ON T6.id = T5.supervisorId
        LEFT JOIN
    academy_location T7 ON T7.id = T2.academyLocationId
     LEFT JOIN
    thesis_management_status T8 on T8.thesisManagementId=T1.id
WHERE T8.status='SUBMITTED' AND T5.id in (namedParams)",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "printName",
            "resultKey": "SUPERVISOR_NAME",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 2
        },
		{
            "id": 4,
            "value": "mobileCountryCode",
            "resultKey": "MOBILE_CODE",
            "displayCode": "",
            "displayOrder": 3
        },
		{
            "id": 5,
            "value": "remarks",
            "resultKey": "REMARKS",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "printName",
            "resultKey": "STUDENT_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 6
        }
    ]
}');

SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='THESIS_SUBMISSION_DL');
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);

SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='THESIS_SUBMISSION');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='THESIS_SUBMISSION');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='THESIS_SUBMISSION_RECIPIENTS');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='GeneralMessage');


INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) 
VALUES(@msgtemplateconfigId+1,'Thesis Submission',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,4,NULL,NULL,'Thesis Submission',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Thesis Submission Detail','<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			 <p align="left">Dear $recipientData[&quot;SUPERVISOR_NAME&quot;],</p>
			 <p align="left">The thesis has been submitted by the $recipientData[&quot;STUDENT_NAME&quot;], Please review and verify. </p>
			</td>
		</tr>
		<tr>
			<td style="padding:20px 20px 20px 20px;">
			<p align="left">Regards<br>Admin<br>$recipientData[&quot;ACADEMY_NAME&quot;]</p></td>
		</tr>
	</tbody>
</table>
</body>
</html>');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'4','Thesis Submission Detail','<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			 <p align="left">Dear $recipientData[&quot;SUPERVISOR_NAME&quot;],</p>
			 <p align="left">The thesis has been submitted by the $recipientData[&quot;STUDENT_NAME&quot;], Please review and verify. </p>
			</td>
		</tr>
		<tr>
			<td style="padding:20px 20px 20px 20px;">
			<p align="left">Regards<br>Admin<br>$recipientData[&quot;ACADEMY_NAME&quot;]</p></td>
		</tr>
	</tbody>
</table>
</body>
</html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+3,@msgtemplateconfigId+1,'6',NULL,'Dear $recipientData[&quot;SUPERVISOR_NAME&quot;], The thesis has been submitted by the $recipientData[&quot;STUDENT_NAME&quot;], Please review and verify.');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+4,@msgtemplateconfigId+1,'2',NULL,'Dear $recipientData[&quot;SUPERVISOR_NAME&quot;], The thesis has been submitted by the $recipientData[&quot;STUDENT_NAME&quot;], Please review and verify.');

SET sql_safe_updates=0;
update msg_template_config set whetherEnabled=1 where whetherEnabled is null;
update msg_template_config set templateLanguageValue ='English' where templateLanguageValue is null;   
SET sql_safe_updates=1;
-- End Messaging for THESIS_SUBMISSION Event